const express = require('express');
const router = express.Router();
const RetryController = require('../controllers/retryController');
const { authenticateApiKey } = require('../middleware/auth');

router.use(authenticateApiKey);

// Reintentar transacción fallida
router.post('/retry', RetryController.retryPayment);

// Listar transacciones fallidas
router.get('/failed', RetryController.getFailedTransactions);

module.exports = router;