const express = require('express');
const router = express.Router();
const PaymentController = require('../controllers/paymentController');
const { authenticateApiKey } = require('../middleware/auth');
const { validatePaymentMovil, validateConsultMovements, validateBanco100Transaction } = require('../middleware/validation');

// Todas las rutas requieren API key
//router.use(authenticateApiKey);

// Validación de pago móvil
router.post('/validate-payment-movil', validatePaymentMovil, PaymentController.validatePaymentMovil);

// Validación de transacción (100% Banco)
router.post('/validate-transaction-100', validateBanco100Transaction, PaymentController.validateTransaction100);

// Consulta de movimientos
router.post('/consult-movements', validateConsultMovements, PaymentController.consultMovements);

// Consulta de estado de transacción
router.get('/transaction/:reference', PaymentController.getTransactionStatus);

module.exports = router;