const db = require('../config/database');

class Bank {
  static async findAll() {
    const [rows] = await db.execute('SELECT * FROM banks WHERE is_active = true');
    return rows;
  }

  static async findByCode(code) {
    const [rows] = await db.execute(
      'SELECT * FROM banks WHERE code = ? AND is_active = true',
      [code]
    );
    return rows[0];
  }

  static async getConfig(bankId) {
    const [rows] = await db.execute(
      'SELECT config_key, config_value, merchant_id, terminal_id, api_secret FROM bank_configs WHERE bank_id = ?',
      [bankId]
    );
    
    const config = {};
    rows.forEach(row => {
      config[row.config_key] = row.config_value;
      config.merchant_id = row.merchant_id;
      config.terminal_id = row.terminal_id;
      config.api_secret = row.api_secret;
    });
    
    return config;
  }
}

module.exports = Bank;