const logger = require('../utils/logger');

const errorHandler = (err, req, res, next) => {
  logger.error('Error no manejado:', err);

  // Error de validación
  if (err.isJoi) {
    return res.status(400).json({
      error: 'Datos de entrada inválidos',
      details: err.details
    });
  }

  // Error de axios (API del banco)
  if (err.response) {
    return res.status(502).json({
      error: 'Error en comunicación con el banco',
      details: err.response.data
    });
  }

  // Error de timeout
  if (err.code === 'ECONNABORTED') {
    return res.status(504).json({
      error: 'Timeout en comunicación con el banco'
    });
  }

  // Error genérico
  res.status(500).json({
    error: 'Error interno del servidor'
  });
};

module.exports = errorHandler;